

   function Directory(url,parent,left,top,width,height,a,b,c,rm){
      var self=this;
      this.rm=rm;
      this.input=null;
      this.context=null;
      this.allowSelectFolders=false;
      this.topLevel="filewear";
      this.currentDirectory="";
      this.selected=[];
      this.clipboard={mode:"",from:"",files:[]};
      this.directory=$('<div>');
      this.directory.css({position:'absolute',top:top,left:left,width:width,height:height,background:'transparent'});
      this.directory.appendTo(parent);
      this.files=$('<div>');
      this.files.css({position:'absolute',top:30,left:0,width:width/2,height:height-60,background:'white','overflow':'auto'});
      this.files.appendTo(this.directory);
      this.toolbar=$('<div>');
      this.toolbar.css({position:'absolute',top:0,left:0,width:width,height:30});
      this.toolbar.addClass('ui-widget-content');
      this.toolbar.appendTo(this.directory);
      this.levelup=$('<button disabled id="uplevel"><img src="icons/_levelup.png"/></button>');
      this.levelup.css({width:28,height:28,border:0});
      this.levelup.appendTo(this.toolbar);
      this.searchinput=$('<input type="text" id="searchinput"/>');
      this.searchinput.css({width:150,height:16,'line-height':16,'font-size':'11px','margin-top':'-5px'});
      this.searchinput.appendTo(this.toolbar);
      this.search=$('<button id="search"><img src="icons/search.png"/></button>');
      this.search.css({width:28,height:28,border:0});
      this.search.appendTo(this.toolbar);
      this.newfolder=$('<button id="newfolder"><img src="icons/new_folder.png"/></button>');
      this.newfolder.css({width:28,height:28,border:0});
      this.newfolder.appendTo(this.toolbar);
      this.delete=$('<button disabled id="delete"><img src="icons/_delete.png"/></button>');
      this.delete.css({width:28,height:28,border:0});
      this.delete.appendTo(this.toolbar);
      //this.upload=$('<form id="fileupload"  method="post" action="'+url+'admin/uploadfiles" enctype="multipart/form-data"></form>');
      //this.upload.css({width:0,height:0,border:0});
      //this.upload.appendTo(this.directory);
      this.uploadinput=$('<input id="uploadinput" type="file" name="upl" multiple>');/*<input id="uploaddirectory" type="hidden" name="directory" value="'+self.currentDirectory+'/"/>');*/
      this.uploadinput.css({width:0,height:0,border:0});
      this.uploadinput.appendTo(this.directory);
      this.uploadbutton=$('<button id="upload"><img src="icons/upload.png"/></button>');
      this.uploadbutton.css({width:28,height:28,border:0});
      this.uploadbutton.appendTo(this.toolbar);
      this.cut=$('<button disabled id="cut"><img src="icons/cut.png"/></button>');
      this.cut.css({width:28,height:28,border:0});
      this.cut.appendTo(this.toolbar);
      this.copy=$('<button disabled id="copy"><img src="icons/copy.png"/></button>');
      this.copy.css({width:28,height:28,border:0});
      this.copy.appendTo(this.toolbar);
      this.paste=$('<button disabled id="paste"><img src="icons/_paste.png"/></button>');
      this.paste.css({width:28,height:28,border:0});
      this.paste.appendTo(this.toolbar);


      this.preview=$('<div>');
      this.preview.css({position:'absolute',top:30,left:width/2,width:width/2,height:height-30,'overflow':'hidden','display': 'table-cell','text-align':'center','vertical-align':'middle'});
      this.preview.appendTo(this.directory);
      this.preview.addClass('ui-widget-content');
      this.previewpane=$('<div>');
      this.previewpane.css({'display':'inline-block',width:'80%',height:'80%','overflow':'hidden','background-position':'center center','background-repeat':'no-repeat','background-size':'contain'});
      this.previewpane.appendTo(this.preview);
      this.preview.addClass('ui-widget-content');

      this.status=$('<div>');
      this.status.css({position:'absolute',top:height-30,left:0,width:width,height:30,'overflow':'hidden'});
      this.status.appendTo(this.directory);
      this.status.addClass('ui-widget-content');
      this.statusitems=$('<div>');
      this.statusitems.css({position:'absolute',top:0,left:0,width:width/6,height:30,'line-height':'30px','text-align':'center','font-size':'11px','overflow':'hidden','border-right':'1px solid #ddd'});
      this.statusitems.appendTo(this.status);
      this.statusselected=$('<div>');
      this.statusselected.css({position:'absolute',top:0,left:width/6,width:width/6,height:30,'line-height':'30px','text-align':'center','font-size':'11px','overflow':'hidden','border-right':'1px solid #ddd'});
      this.statusselected.appendTo(this.status);
      this.statusclipboard=$('<div>');
      this.statusclipboard.css({position:'absolute',top:0,left:width/3,width:width/6,height:30,'line-height':'30px','text-align':'center','font-size':'11px','overflow':'hidden','border-right':'1px solid #ddd'});
      this.statusclipboard.appendTo(this.status);
      this.progress=$('<div id="progressbar"></div>');
      this.progress.css({position:'absolute',top:0,left:width/2,width:(width/2)-10,height:20,padding:5});
      this.progress.appendTo(this.status);
      this.progresslabel=$('<div id="progresslabel"></div>');
      this.progresslabel.css({position:'absolute',top:0,left:'50%',height:30,'line-height':'30px'});
      this.progresslabel.appendTo(this.progress);


      $('#progressbar').progressbar({
        value: false,
        change: function() {
          $('#progresslabel').text( $('#progressbar').progressbar( "value" ) + "%" );
        },
        complete: function() {
          $('#progresslabel').text( "Complete" );
          setTimeout(function(){
            $('#progressbar').progressbar( "value",0 );
            $('#progresslabel').text( "" );
          },5000)
        }
      });


      this.setInput=function(context,el){
         self.context=context;
         self.input=el;
      }

      this.selectFile=function(){
         return self.currentDirectory+"/"+$('#fileinput').val();
      }

      this.showPreview=function(el){
         var image;
         if(el.data('filetype')=="jpg"||el.data('filetype')=="png"||el.data('filetype')=="gif"){
            //image="url('"+url+el.data('path')+"')";
            image="url('"+self.rm.getResource(el.data('path'))+"')";

         }
         else if(el.data('filetype')=="fldr" ){
            image="url('icons/folder_128.png')";
         }
         else if(el.data('filetype')=="pdf" ){
            image="url('icons/pdf_128.png')";
         }
         else if(el.data('filetype')=="html"||el.data('filetype')=="htm" ){
            image="url('icons/html_128.png')";
         }
         else{
            image="url('icons/unknown_128.png')";
         }
         self.previewpane.css({'background-image':image});
      }

      this.setRoot=function()
      {
      }

      this.setMode=function()
      {
      }

      this.getFiles=function(directory){
         //$.post(url+'admin/getfilelist',{directory:directory},function(data){
            //self.display(data,directory);
         //},'json')
         var files=self.rm.getFiles(directory);
      }

      this.display=function(data,directory,item){
         //alert(JSON.stringify(data,null,2));
         var list='<ul class="container">';
         var key=directory+"/";
         var directories=0;
         var files=0;
         for(i=0;i<data.Contents.length;i++){
            var path=data.Contents[i].Key.replace(key,"");//.split("/");
            if(path.endsWith("/")){//is directory
              path=path.split("/");
              //alert(path)
              if(path.length==2){
                 var dataPath=data.Contents[i].Key.replace(/\/+$/, "");
                 list+='<li data-path="'+dataPath+'"';
                 list+='class="fldr" data-filetype="fldr" ';
                 list+='data-name="'+data.Contents[i].Key+'"';
                 list+=' title="'+data.Contents[i].Key+'"';
                 list+='>'+path[0]+'</li>';
                 directories++;
              }
            }
         }
         for(i=0;i<data.Contents.length;i++){
            var path=data.Contents[i].Key.replace(key,"");
            if(!path.endsWith("/")){//is file
              path=path.split("/");
              if(path.length==1){
                  var ext=path[0].split(".");
                  list+='<li data-path="'+data.Contents[i].Key+'" class="'+ext[1].toLowerCase()+'" data-name="'+path[0]+'" data-filetype="'+ext[1].toLowerCase()+'">'+path[0]+'</li>';
                  files++;
              }
            }
         }
         list+='</ul>';
         self.files.html(list);
         self.currentDirectory=directory;
         $('#uploaddirectory').val(self.currentDirectory+"/");
         if(self.currentDirectory!=self.topLevel){
            $('#uplevel img').attr('src','icons/levelup.png');
            $('#uplevel').attr('disabled',false);
         }
         else{
            $('#uplevel img').attr('src','icons/_levelup.png');
            $('#uplevel').attr('disabled',true);
         }
         self.selected=[];
         self.updateToolbar();
         var count=(directories+files);
         var items=count>0&&count<2?" item":" items";
         self.statusitems.text(count+items);
         self.statusselected.text('0 selected');
         if(item){
            var select=$(self.files).find("li:contains('"+item+"')");
            select.trigger("click");
            var pos=select.position();
            $(self.files).scrollTop(pos.top-5);
         }

      }

      this.updateToolbar=function(){
         if(self.selected.length>0){
            $('#delete img').attr('src','icons/delete.png');
            $('#cut img').attr('src','icons/cut.png');
            $('#copy img').attr('src','icons/copy.png');
            $('#delete,#cut,#copy').attr('disabled',false);
            $('#delete').attr('disabled',false);
         }
         else{
            $('#delete img').attr('src','icons/_delete.png');
            $('#cut img').attr('src','icons/_cut.png');
            $('#copy img').attr('src','icons/_copy.png');
            $('#delete,#cut,#copy').attr('disabled',true);
         }
         self.statusselected.text(self.selected.length+' selected');
      }

      $(self.files).click(function(){
         $('.container li').removeClass('filesearch');
      })

      $('.container li').mousedown(function(e){
         e.preventDefault();
      });

      //$('.container li').tooltip();

      $('.container li').live('click',function(e){
          self.showPreview($(this));
          $('#fileinput').val($(this).hasClass('fldr')?'':$(this).data('name'));
          //alert($(this).data('name'));
          if(e.ctrlKey){
             self.selected.push($(this));
          }
          else{
             self.selected=[];
             self.selected.push($(this));
          }
          $('.container li').removeClass('fileselected');
          for(i=0;i<self.selected.length;i++){
             self.selected[i].addClass('fileselected');
          }
          self.updateToolbar();
      })

      $('.fldr').live('dblclick',function(e){
         self.getFiles($(this).data('path'));
      })

      $('#uplevel').click(function(){
         var current=self.currentDirectory.split("/");
         current.pop();
         var uplevel=current.join("/");
         self.getFiles(uplevel);
      })

      $('#search').click(function(){
         var search=$('#searchinput').val().toUpperCase();
         self.doSearch(search);
      })

      this.doSearch=function(search){
         if(search!=""){
            $('.container li').each(function(){
              if($(this).text().toUpperCase().indexOf(search)>-1){
                  $(this).addClass('filesearch');
                  var pos=$(this).position();
                  $(self.files).scrollTop(pos.top-5);
              }
            })
         }
      }

      $('#newfolder').click(function(){
        var name=prompt("Please enter a folder name");
        var directories=$('.container li.fldr');
        var invalid=/[<>:"\/\\|?*\x00-\x1F]/;
        //check not empty
        if(name.length<1){
           alert("A folder name must be entered");
           $('#newfolder').trigger('click');
        }
        //check for invalid chars
        if(invalid.test(name)){
           alert("The folder name contains illegal characters");
           $('#newfolder').trigger('click');
        }
        $.each(directories,function(){
           if($(this).text()==name){
              alert("The folder name already exists");
              $('#newfolder').trigger('click');
           }
        })
        self.rm.newDirectory(self.currentDirectory,name);
         /*$.post(url+'admin/addfolder',{directory:self.currentDirectory},function(data){
            self.display(data,self.currentDirectory);
         },'json')*/
      })

      $('#delete').click(function(){
         var selected=self.selected.length;
         if(selected>0){
            var items=selected>1?" these items?":" this item?";
            if(confirm("Permanently delete"+items)){
               var keys=[];
               for(i=0;i<self.selected.length;i++){
                   var path=self.selected[i].hasClass('fldr')?self.selected[i].data('path')+"/":self.selected[i].data('path');
                   alert(path);
                   keys.push(path);
               }
               self.rm.deleteObjects(self.currentDirectory,keys);
               /*var params=['directory='+self.currentDirectory];
               for(i=0;i<self.selected.length;i++){
                  params.push("files[]="+self.selected[i].data('path'));
               }
               $.post(url+'admin/deletefile',params.join("&"),function(data){
                  self.display(data,self.currentDirectory);
               },'json')*/
            }
         }
      })

      $('#cut').click(function(){
          self.clipboard.files=[];
          self.clipboard.mode="cut";
          self.clipboard.from=self.currentDirectory;
          for(i=0;i<self.selected.length;i++)self.clipboard.files.push(self.selected[i]);
          $('#paste img').attr('src','icons/paste.png');
          $('#paste').attr('disabled',false);
          self.statusclipboard.text(self.clipboard.files.length+" cut");
      })

      $('#copy').click(function(){
          self.clipboard.files=[];
          self.clipboard.mode="copy";
          self.clipboard.from=self.currentDirectory;
          for(i=0;i<self.selected.length;i++)self.clipboard.files.push(self.selected[i]);
          $('#paste img').attr('src','icons/paste.png');
          $('#paste').attr('disabled',false);
          self.statusclipboard.text(self.clipboard.files.length+" copied");
      })

      $('#paste').click(function(){
         var selected=self.clipboard.files;
         var mode=self.clipboard.mode;
         var from=self.clipboard.from;
         if(selected.length>0){
            var items=[];
            for(i=0;i<selected.length;i++){
               var path=selected[i].hasClass('fldr')?selected[i].text()+"/":selected[i].text();
               var type=selected[i].hasClass('fldr')?"folder":"file";
               var item={path:path,type:type};
               items.push(item);
            }
            self.clipboard.files=[];
            self.rm.pasteObjects(from,self.currentDirectory,mode,items);
            $('#paste img').attr('src','icons/_paste.png');
            $('#paste').attr('disabled',true);
            self.statusclipboard.text('');
         }
      })

      $('#upload').click(function(){
         $('#uploadinput').click();
      })

      $('#uploadinput').change(function(){
          var files = $(this).get(0).files;
          self.rm.uploadFiles(self.currentDirectory,files);

      })



      $(self.files).bind('dragenter', function (e)
      {
          e.stopPropagation();
          e.preventDefault();
          //$(this).css('border', '2px solid #0B85A1');
      });
      $(self.files).bind('dragover', function (e)
      {
           e.stopPropagation();
           e.preventDefault();
      });
      $(self.files).bind('drop', function (e)
      {
       
           //$(this).css('border', '2px dotted #0B85A1');
           e.preventDefault();
           var files = e.originalEvent.dataTransfer.files;
           self.rm.uploadFiles(self.currentDirectory,files);
           //We need to send dropped files to Server
           //handleFileUpload(files,obj);
      });

       this.formatFileSize=function(bytes) {
          if (typeof bytes !== 'number') {
             return '';
          }
          if (bytes >= 1000000000) {
             return (bytes / 1000000000).toFixed(2) + ' GB';
          }
          if (bytes >= 1000000) {
             return (bytes / 1000000).toFixed(2) + ' MB';
          }
          return (bytes / 1000).toFixed(2) + ' KB';
       }
      try{
      this.getFiles(this.topLevel);
      }
      catch(e){
        alert(e);
      }

   }